#include "univ.h"
#include <Xol/Menu.h>
#include <Xol/Form.h>
#include <Xol/ControlAre.h>
#include <Xol/MenuButton.h>
#include <Xol/OblongButt.h>
#include <Xol/ScrolledWi.h>
#include <Xol/Caption.h>
#include <Xol/StaticText.h>

int keyinputclosed;
Widget keytextw;

static Widget keywindowlabel;
static Widget keylinelabel;
static Widget windowsmenupane;
static Widget hostbusy;
static TextBuffer *keytextbuf;
static void KeyInputMapEH();
static void keypostmodifyCB();

keyinputsetup()
{
	Widget keyw;
	Widget form;
	Widget control;
	Widget windowbutton;
	Widget scrollwin;
	Widget caption1, caption2;

	keyw = XtVaAppCreateShell("keyboard", "Pads", topLevelShellWidgetClass,
		XtDisplay(basepane),
		XtNtitle, "Keyboard Input",
		XtNiconName, "pi",
		NULL);
	XtAddEventHandler(keyw, StructureNotifyMask, FALSE,
		KeyInputMapEH, NULL);

	form = XtVaCreateManagedWidget("keyinput", formWidgetClass, keyw,
		NULL);

	control = XtVaCreateManagedWidget("control", controlAreaWidgetClass,
		form,
		XtNhSpace, 10,
		NULL);

	windowbutton = XtVaCreateManagedWidget("windows", menuButtonWidgetClass,
		control,
		XtNpushpin, OL_OUT,
		NULL);
	XtVaGetValues(windowbutton, XtNmenuPane, &windowsmenupane, NULL);

	caption1 = XtVaCreateManagedWidget("Window:", captionWidgetClass,
		control, NULL);
	keywindowlabel = XtVaCreateManagedWidget("window",staticTextWidgetClass,
		caption1,
		XtNstring, "Dummy Window",
		XtNrecomputeSize, FALSE,
		XtNwrap, FALSE,
		XtNgravity, WestGravity,
		NULL);

	caption2 = XtVaCreateManagedWidget("Line:", captionWidgetClass,
		control, NULL);
	keylinelabel = XtVaCreateManagedWidget("line", staticTextWidgetClass,
		caption2,
		XtNstring, "None",
		XtNrecomputeSize, FALSE,
		XtNwrap, FALSE,
		XtNgravity, WestGravity,
		NULL);

	hostbusy = XtVaCreateManagedWidget("busy", staticTextWidgetClass,
		control,
		XtNstring, "Busy",
		XtNrecomputeSize, FALSE,
		XtNwrap, FALSE,
		XtNgravity, WestGravity,
		XtNmappedWhenManaged, FALSE,
		NULL);

	scrollwin = XtVaCreateManagedWidget("scrollw",scrolledWindowWidgetClass,
		form,
		XtNyRefWidget, control,
		XtNyAddHeight, TRUE,
		XtNxResizable, TRUE,
		XtNyResizable, TRUE,
		XtNyAttachBottom, TRUE,
		XtNxAttachRight, TRUE,
		NULL);

	keytextw = XtVaCreateManagedWidget("text", textEditWidgetClass,
		scrollwin,
		XtNwrapMode, OL_WRAP_OFF,
		NULL);
	keytextbuf = OlTextEditTextBuffer(keytextw);
	XtAddCallback(keytextw, XtNpostModifyNotification, keypostmodifyCB,
		NULL);

	XtRealizeWidget(keyw);
}


static void
KeyInputMapEH(w, ptr, ev)
Widget w;
caddr_t *ptr;
XEvent *ev;
{
	register Pad *p;

	switch (ev->type) {
	case UnmapNotify:
		keyinputclosed = 1;
		if (LineShell != (Widget)NULL)
			XtPopdown(LineShell);
		for (p = Sentinel.back; ISPAD(p); p = p->back)
			if (p->haswindow) {
				PadUnmapPopups(p);
				XtUnmapWidget(p->pane);
			}
		break;
	case MapNotify:
		keyinputclosed = 0;
		for (p = Sentinel.back; ISPAD(p); p = p->back)
			if (p->haswindow) {
				XtMapWidget(p->pane);
				PadMapPopups(p);
			}
		break;
	}
}

static void
keypostmodifyCB(tw, udata, cd)
Widget tw;
caddr_t udata;
OlTextPostModifyCallData *cd;
{
	char *cp;
	TextPosition last, lasti;
	TextPosition start;
	int sendlines, line;

	if (!cd->requestor
	    || !cd->inserted
	    || !strchr(cd->inserted, '\n'))
		return;
	last = LastTextBufferPosition(keytextbuf);
	lasti = PositionOfLocation(keytextbuf, cd->insert_end);
	if (last != lasti)
		return;
	for (sendlines = 0, cp = cd->inserted; *cp; cp++)
		if (*cp == '\n')
			sendlines++;
	for (line = cd->insert_start.line; sendlines--; line++) {
		cp = GetTextBufferLine(keytextbuf, line);
		KeySendString(cp);
		free(cp);
	}
}

static void
NameMenuCB(w, p, call_data)
Widget w;
Pad *p;
XtPointer call_data;
{
	MakeCurrent(p);
}

AddNameMenuEntry(p)
Pad *p;
{
	p->namemenuentry = XtVaCreateManagedWidget(p->name,
		oblongButtonWidgetClass,
		windowsmenupane,
		XtNlabelJustify, OL_CENTER,
		NULL);
	XtAddCallback(p->namemenuentry, XtNselect, NameMenuCB, (XtPointer)p);
}

ChangeNameMenuEntry(p)
Pad *p;
{
	XtVaSetValues(p->namemenuentry, XtNlabel, p->name, NULL);
}

DeleteNameMenuEntry(p)
Pad *p;
{
	XtDestroyWidget(p->namemenuentry);
}

UpdateKeyLabels(p, l)
Pad *p;
int l;
{
	static char none[] = "None";
	char id[10];
	char *s;
	static Pad *oldp;

	if (p != oldp) {
		XtVaSetValues(keywindowlabel,
			XtNstring, p ? p->name : none,
			NULL);
		oldp = p;
	}
	if (l == -1)
		s = none;
	else {
		s = id;
		sprintf(id, "%d", l + 1);
	}
	XtVaSetValues(keylinelabel, XtNstring, s, NULL);
}

KeyWindowMessage(s)
char *s;
{
	TextLocation loc;
	TextPosition pos;

	loc = LastTextBufferLocation(keytextbuf);
	ReplaceBlockInTextBuffer(keytextbuf, &loc, &loc, s, NULL, NULL);
	pos = LastTextBufferPosition(keytextbuf);
	OlTextEditSetCursorPosition(keytextw, pos, pos, pos);
}

ShowHostState(busy)
int busy;
{
	if (busy)
		XtMapWidget(hostbusy);
	else
		XtUnmapWidget(hostbusy);
}
